import requests
import json
import typing

from Deadline.Scripting import ClientUtils, MonitorUtils, RepositoryUtils
from Deadline.Jobs import Job, JobStatus

from DeadlineUI.Controls.Scripting.DeadlineScriptDialog import DeadlineScriptDialog
from ThinkboxUI.Controls.Scripting.ButtonControl import ButtonControl

def __main__():
    global scriptDialog

    scriptDialog = StopDialog()
    # Add control buttons
    scriptDialog.AddGrid()
    scriptDialog.AddHorizontalSpacerToGrid( "HSpacer", 0, 0 )
    okButton = scriptDialog.AddControlToGrid( "OkButton", "ButtonControl", "Yes", 0, 1, expand=False )
    okButton.clicked.connect( OKButtonClicked )
    cancelButton = scriptDialog.AddControlToGrid( "CancelButton", "ButtonControl", "No", 0, 2, expand=False )
    cancelButton.clicked.connect( CancelButtonClicked )
    scriptDialog.EndGrid()
    scriptDialog.ShowDialog( True )

def OKButtonClicked():
    # type: () -> None
    super( StopDialog, scriptDialog ).accept()

    try:
        selectedJobs = MonitorUtils.GetSelectedJobs()
        job = selectedJobs[0]
        print("JobId: %s" % job.ExtraInfo1)
        print("ProjectId: %s" % job.ExtraInfo0)
        StopGridMarketsJob(job)
    except Exception as e:
        super( StopDialog, scriptDialog ).ShowMessageBox( "Error stopping job: %s" % str(e), "Error" )

def CancelButtonClicked():
    # type: () -> None
    super( StopDialog, scriptDialog ).reject()

def StopGridMarketsJob(job):
    gmJobId = job.ExtraInfo1
    gmProjectId = job.ExtraInfo0

    print("Stopping GridMarkets job...")
    url = "http://localhost:8090/submissions/%s/jobs/%s?action=stop" % (gmProjectId, gmJobId)
    headers = {"Content-Type": "application/json"}
    data = {"params": {"reason": "No longer needed"}}
    
    try:
        response = requests.post(url, headers=headers, data=json.dumps(data))
        if response.status_code == 200 or response.status_code == 201  or response.status_code == 202:
            print(f"Status Code: {response.status_code}")
            print(f"Response: {response.json()}")
            super( StopDialog, scriptDialog ).ShowMessageBox( "Stopping job", "Info" )
        else:
            if response.status_code == 401:
                raise Exception("Please login to Envoy.")
            else:
                raise Exception(f"{response.json()}")
    except Exception as e:
        print(f"Error stopping job: {str(e)}")
        super( StopDialog, scriptDialog ).ShowMessageBox( "Error stopping job: %s" % str(e), "Error" )
        

########################################################################
## Subclass of DeadlineScriptDialog for the UI
########################################################################
class StopDialog( DeadlineScriptDialog ):

    def __init__( self, parentAppName="", parent=None ):
        # type: (str, Optional[Any]) -> None
        super( StopDialog, self ).__init__( parent )
        self.SetTitle( "Stop Job" )
        self.AddControl( "StopText", "LabelControl", "Are you sure, do you want to stop this job?", 480, -1 )

    @classmethod
    def ShowMessageBox( cls, message, title="Info" ):
        # type: (str, str) -> None
        if cls is not None:
            ClientUtils.ShowMessageBox( message, title )
        else:
            print( "{}: {}".format( title, message ) )

########################################################################
## Globals
########################################################################
# down here to ensure all functions/classes exist
if typing.TYPE_CHECKING:
    scriptDialog = StopDialog()
else:
    scriptDialog = None

